
#Extended Data Table 4 - Results


#-----------------------------------------------------------------#
#### MAU and Modified General Utility Index #### 
#-----------------------------------------------------------------#

# Prepare data and packages

## Attaching package: "dplyr"
library(dplyr)

## Attaching package: "modEvA"
library(modEvA)

## Attaching package: "lmtest"
library(lmtest)

# Attaching package: "zoo"
library(zoo)

# Load data on MGUI and MAU "MGUI.csv"
MGUI_data <- read.csv("MGUI.csv", header = T, sep = ";")

# See structure of databaframe
str(MGUI_data)

##plot MAU as a function of MGUI
plot(MGUI_data$MAU ~ MGUI_data$MGUI, data = MGUI_data, pch = 19, col = "#00000050",
     xlab = "MGUI", ylab = "MAU")

#model this relationship 
##fit a log normal GLM to the data (since the data theoretically range from 0 to positive infinity)
surv.glm <- glm(MGUI_data$MAU ~ MGUI_data$MGUI, data = MGUI_data, family = gaussian(link = "log"))
summary(surv.glm)

# Using the surv.glm model object from above to calculate D-squared manually
## GLM equivalent of R-squared
manual_dsquared <- 1 - (surv.glm$deviance / surv.glm$null.deviance)
print(manual_dsquared)

#calculate a p-value
lmtest::lrtest(surv.glm)


#-----------------------------------------------------------------#
#### MAU and Simplified Meat Utility Index #### 
#-----------------------------------------------------------------#

# Load data on SMUI and MAU "SMUI.csv"
SMUI_data <- read.csv("SMUI.csv", header = T, sep = ";")

# See structure of databaframe
str(SMUI_data)

##plot MAU as a function of SMUI
plot(SMUI_data$MAU ~ SMUI_data$SMUI, data = SMUI_data, pch = 19, col = "#00000050",
     xlab = "SMUI", ylab = "MAU")

#model this relationship 
##fit a log normal GLM to the data (since the data theoretically range from 0 to positive infinity)
surv.glm <- glm(SMUI_data$MAU ~ SMUI_data$SMUI, data = SMUI_data, family = gaussian(link = "log"))
summary(surv.glm)

# Using the surv.glm model object from above to calculate D-squared manually
## GLM equivalent of R-squared
manual_dsquared <- 1 - (surv.glm$deviance / surv.glm$null.deviance)
print(manual_dsquared)

#calculate a p-value
lmtest::lrtest(surv.glm)



#-----------------------------------------------------------------#
#### MAU and Food Utility Index #### 
#-----------------------------------------------------------------#

# Load data on FUI and MAU "FUI.csv"
FUI_data <- read.csv("FUI.csv", header = T, sep = ";")

# See structure of databaframe
str(FUI_data)

##plot MAU as a function of FUI
plot(FUI_data$MAU ~ FUI_data$FUI, data = FUI_data, pch = 19, col = "#00000050",
     xlab = "FUI", ylab = "MAU")

#model this relationship 
##fit a log normal GLM to the data (since the data theoretically range from 0 to positive infinity)
surv.glm <- glm(FUI_data$MAU ~ FUI_data$FUI, data = FUI_data, family = gaussian(link = "log"))
summary(surv.glm)

# Using the surv.glm model object from above to calculate D-squared manually
## GLM equivalent of R-squared
manual_dsquared <- 1 - (surv.glm$deviance / surv.glm$null.deviance)
print(manual_dsquared)

#calculate a p-value
lmtest::lrtest(surv.glm)



#-----------------------------------------------------------------#
#### MAU and Corrected Food Utility Index #### 
#-----------------------------------------------------------------#

# Load data on CFUI and MAU "CFUI.csv"
CFUI_data <- read.csv("CFUI.csv", header = T, sep = ";")

# See structure of databaframe
str(CFUI_data)

##plot MAU as a function of CFUI
plot(CFUI_data$MAU ~ CFUI_data$CFUI, data = CFUI_data, pch = 19, col = "#00000050",
     xlab = "CFUI", ylab = "MAU")

#model this relationship 
##fit a log normal GLM to the data (since the data theoretically range from 0 to positive infinity)
surv.glm <- glm(CFUI_data$MAU ~ CFUI_data$CFUI, data = CFUI_data, family = gaussian(link = "log"))
summary(surv.glm)

# Using the surv.glm model object from above to calculate D-squared manually
## GLM equivalent of R-squared
manual_dsquared <- 1 - (surv.glm$deviance / surv.glm$null.deviance)
print(manual_dsquared)

#calculate a p-value
lmtest::lrtest(surv.glm)


#-----------------------------------------------------------------#
#### MAU and Unsaturated Marrow Index #### 
#-----------------------------------------------------------------#

# Load data on UMI and MAU "UMI.csv"
UMI_data <- read.csv("UMI.csv", header = T, sep = ";")

# See structure of databaframe
str(UMI_data)

##plot MAU as a function of UMI
plot(UMI_data$MAU ~ UMI_data$UMI, data = UMI_data, pch = 19, col = "#00000050",
     xlab = "UMI", ylab = "MAU")

#model this relationship 
##fit a log normal GLM to the data (since the data theoretically range from 0 to positive infinity)
surv.glm <- glm(UMI_data$MAU ~ UMI_data$UMI, data = UMI_data, family = gaussian(link = "log"))
summary(surv.glm)

# Using the surv.glm model object from above to calculate D-squared manually
## GLM equivalent of R-squared
manual_dsquared <- 1 - (surv.glm$deviance / surv.glm$null.deviance)
print(manual_dsquared)

#calculate a p-value
lmtest::lrtest(surv.glm)


#-----------------------------------------------------------------#
#### Skeletal element survival and density mediated attrition #### 
#-----------------------------------------------------------------#

# Load data on Bone mineral density and survivorship (%MAU) "Density.csv"
density_data <- read.csv("Density.csv", header = T, sep = ";")

# See structure of databaframe
str(density_data)

##plot survivorship (%MAU) as a function of bone mineral density
plot(density_data$Survivorship ~ density_data$Density, data = density_data, pch = 19, col = "#00000050",
     xlab = "Bone Mineral Density", ylab = "Survivorship - %MAU")

#model this relationship 
##fit a log normal GLM to the data (since the data theoretically range from 0 to positive infinity)
surv.glm <- glm(density_data$Survivorship ~ density_data$Density, data = density_data, family = gaussian(link = "log"))
summary(surv.glm)

# Using the surv.glm model object from above to calculate D-squared manually
## GLM equivalent of R-squared
manual_dsquared <- 1 - (surv.glm$deviance / surv.glm$null.deviance)
print(manual_dsquared)

#calculate a p-value
lmtest::lrtest(surv.glm)


